// scriptDoc.cpp : implementation of the CScriptDoc class
//

#include "stdafx.h"
#include "script.h"

#include "scriptDoc.h"
#include "scriptView.h"
#include "ScriptEngine.h"
//#include "OutputDialog2.h"
#include "NewOutputDialog.h"
#include "OutputWindow.h"
#include "GotoLineDialog.h"
#include "FunctionListDialog.h"
#include "ExecuteDialog.h"
#include "FindDialog.h"
#include "InputLineDialog.h"

#include "utility.h"
#include "CStringEx.h"

#undef _DEBUG // EMP DIKEO

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern HWND ghwndMain;
extern BOOL gbScriptRunning;
extern bool gbLaunching;
extern bool gbSquelchAutoLaunch;
extern bool gbForceAllowOpen;
extern bool gbEnterModalLoop;
extern LaunchModeType gLaunchMode;
extern class CScriptEngine * pENGINE;
extern CWnd *gpcwndMain;
extern bool gbFileHasValidChecksum;
extern bool gbScrollToError;
extern bool gbHasPrefsFile;
extern bool gbOverrideRunActivate;
extern CScriptApp theApp;

extern HCURSOR ghCursorNormal;

extern bool gbShowEditorWindow;	//Is the main window shown?
extern bool gbAllowEmptyLaunch;	//Can the app be launched without a file?
extern bool gbCloseOnEnd;		//Does entire app close when program exits?
extern bool gbAllowSave;		//Can apps be saved?
extern bool gbCanOpenPlainFiles; //Can we open non-checksummed files?
extern bool gbProtectedFile;	//Is the file protected (not editable?)
extern TCHAR gszRealFilename[];   //used when opening the magic file to hold the real path..
extern unsigned long giSerialNumber;
extern wchar_t gszLastPath[];

extern DWORD gdwPrefFlags;

extern BOOL gbTrace;
extern BOOL gbStep;

extern CScriptDoc *gpCurrentDocument;
class COutputWindow *gpOutputWindow;

#define UTF8

//class OutputDialog dlgOutput;

/////////////////////////////////////////////////////////////////////////////
// CScriptDoc

IMPLEMENT_DYNCREATE(CScriptDoc, CDocument)

BEGIN_MESSAGE_MAP(CScriptDoc, CDocument)
	//{{AFX_MSG_MAP(CScriptDoc)
	ON_COMMAND(ID_TOOL_RUN, OnToolRun)
	ON_COMMAND(ID_TOOLS_EXECUTECODE, OnToolsExecutecode)
	ON_COMMAND(ID_TOOLS_SHOWVARIABLE, OnToolsShowvariable)
	ON_COMMAND(ID_TOOLS_CONTINUE, OnToolsContinue)
	ON_UPDATE_COMMAND_UI(ID_TOOLS_CONTINUE, OnUpdateToolsContinue)
	ON_COMMAND(ID_TOOLS_STATS, OnToolsStats)
	ON_UPDATE_COMMAND_UI(ID_FILE_SAVE_AS, OnUpdateFileSaveAs)
	ON_UPDATE_COMMAND_UI(ID_TOOLS_EXECUTECODE, OnUpdateToolsExecutecode)
	ON_UPDATE_COMMAND_UI(ID_TOOLS_SHOWVARIABLE, OnUpdateToolsShowvariable)
	ON_UPDATE_COMMAND_UI(ID_TOOLS_STATS, OnUpdateToolsStats)
	ON_UPDATE_COMMAND_UI(ID_TOOL_RUN, OnUpdateToolRun)
	ON_COMMAND(ID_RUNBUTTON, OnRunbutton)
	ON_UPDATE_COMMAND_UI(ID_RUNBUTTON, OnUpdateRunbutton)
	ON_UPDATE_COMMAND_UI(ID_FILE_SAVE, OnUpdateFileSave)
	ON_UPDATE_COMMAND_UI(ID_FILE_NEW, OnUpdateFileNew)
	ON_UPDATE_COMMAND_UI(ID_FILE_OPEN, OnUpdateFileOpen)
	ON_UPDATE_COMMAND_UI(ID_FILE_SAVE_ENCRYPTED, OnUpdateFileSaveEncrypted)
	ON_COMMAND(ID_FILE_SAVE_ENCRYPTED, OnFileSaveEncrypted)
	ON_COMMAND(ID_TOOLS_STEP, OnToolsStep)
	ON_COMMAND(ID_TOOLS_TRACE, OnToolsTrace)
	ON_COMMAND(ID_TOOLS_DESIGNER, OnToolsDesigner)
	ON_UPDATE_COMMAND_UI(ID_TOOLS_STEP, OnUpdateRunbutton)
	ON_UPDATE_COMMAND_UI(ID_TOOLS_TRACE, OnUpdateRunbutton)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CScriptDoc construction/destruction

CScriptDoc::CScriptDoc()
{
	gpCurrentDocument=this; //this only works because we are SDI.  
	isExe = FALSE;
}

CScriptDoc::~CScriptDoc()
{
}

BOOL CScriptDoc::OnNewDocument()
{
	const TCHAR *szTempPath=kMagicVNSBFilePath;

   doWriteDebug(TEXT("18"));
	if(gpOutputWindow)
		gpOutputWindow->m_bLaunchedWithFile=false; //prevent auto-close of entire app

	if (!CDocument::OnNewDocument())
		return FALSE;

	isExe = FALSE;

	//**JULY99 - fix for #212
	DeleteFile(szTempPath);

	if(gbShowEditorWindow) //don't allow this if the window isn't showing (duh)
		gbFileHasValidChecksum=true;
	CEditView *pView=((CEditView*)m_viewList.GetHead());
	if(pView)
		pView->SetWindowText(L"");
	// TODO: add reinitialization code here
	// (SDI documents will reuse this document)
	CWnd *pWnd=AfxGetMainWnd();
	if(!pWnd)
		pWnd=gpcwndMain;
	if(pWnd)
		pWnd->SetWindowText(TEXT("BASIC Editor"));
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CScriptDoc serialization

void CScriptDoc::Serialize(CArchive& ar)
{
	ASSERT_VALID(this);

	if ((!isExe) && gbHasPrefsFile)
	{
		CFile* pFile = ar.GetFile();

		CString pathName = pFile -> GetFilePath();
		_tcsncpy(gszLastPath, pathName, MAX_PATH);

		doWritePrefsFile();
	}

	if (ar.IsStoring())
	{
		if (!isExe)
		{
			WriteToArchive(ar);
		}
	}
	else
	{
		if (isExe)
		{
			CFile* pFile = ar.GetFile();

			wchar_t lpszPathName[MAX_PATH + 1];
			CString pathName = pFile -> GetFilePath();
			_tcsncpy(lpszPathName, pathName, MAX_PATH);
#if _WIN32_WCE >= 300
			HINSTANCE lib = LoadLibraryEx(pathName, NULL, LOAD_LIBRARY_AS_DATAFILE);
#else
			HINSTANCE lib = LoadLibrary(pathName);
#endif
			if (lib)
			{
				HRSRC rsc = FindResource(lib, MAKEINTRESOURCE(IDS_PROGRAMSTRING), RT_RCDATA);
				if (rsc)
				{
					HGLOBAL hRes = LoadResource(lib, rsc);
					if (hRes)
					{
#ifdef UTF8
						char *d = (char *)LockResource(hRes);
						ReadFromFile(pFile, strlen(d), m_strCode);
#else
						wchar_t *d = (wchar_t *)LockResource(hRes);
						ReadFromFile(pFile, wcslen(d), m_strCode);
#endif
					}

				}
				else
				{
					LPCTSTR contents;

					contents = (LPCTSTR)LoadString(lib, IDS_PROGRAMSTRING, NULL, 0);
					if (contents)
					{
						ReadFromFile(pFile, wcslen(contents), m_strCode);
					}
					else
					{
						MessageBox(NULL, L"Could not find program in executable", L"ERROR", MB_OK);
					}
				}
				FreeLibrary(lib);
			}
			else
			{
				MessageBox(NULL, L"This program requres Windows CE 3.0 or better.", L"ERROR", MB_OK);
				return;
			}
		}
		else
		{
			CFile* pFile = ar.GetFile();
			ASSERT(pFile->GetPosition() == 0);
			DWORD nFileSize = pFile->GetLength();

			gbFileHasValidChecksum=false;

			if (nFileSize/sizeof(TCHAR) > CScriptView::nMaxSize)
			{
				AfxMessageBox(AFX_IDP_FILE_TOO_LARGE);
				AfxThrowUserException();
			}

			// ReadFromArchive takes the number of characters as argument
	//		ReadFromArchive(ar, (UINT)nFileSize/sizeof(TCHAR));
			ReadFromFile( pFile, (UINT)nFileSize/sizeof(TCHAR), m_strCode );
			// 2003-05-20:Delete the following line, if file problems occur after 
			//pFile->Close();
		}
	}
	ASSERT_VALID(this);
}

/////////////////////////////////////////////////////////////////////////////
// CScriptDoc diagnostics

#undef _DEBUG // EMP DIKEO

#ifdef _DEBUG
void CScriptDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CScriptDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG




/////////////////////////////////////////////////////////////////////////////
// CScriptDoc commands



BOOL CScriptDoc::EnsureOutputWindowOpen()
{//open the output window if it is not already open, init the environment, and run the preamble script
	RECT rectClient;

   doWriteDebug(TEXT("19"));
	if(gpOutputWindow)
	{
		//gpOutputWindow->BringWindowToTop();
		//gpOutputWindow->ShowWindow(SW_SHOW);
		return true;
	}

	gpOutputWindow=new COutputWindow;
	gpOutputWindow->LoadFrame(IDR_OUTPUTFRAME,WS_OVERLAPPED|WS_CAPTION,0,NULL);
#ifdef _POCKET
   CString strTitle = GetTitle();
   int nLen = strTitle.GetLength();
   CString strExt = strTitle.Right( 4 );
   if( strExt.CompareNoCase( _T( ".nsb" ) ) == 0 )
      nLen -= 4;
   if( strExt.CompareNoCase( _T( ".exe" ) ) == 0 )
      nLen -= 4;
	gpOutputWindow->SetWindowText( strTitle.Left( nLen ) );
#else
	gpOutputWindow->SetWindowText(GetTitle());
#endif
	CNewOutputDialog *pDlgOutput=&(gpOutputWindow->dlgOutput);

	if(!pDlgOutput->Create(IDD_OUTPUTDIALOG,gpOutputWindow/*gpcwndMain*//*AfxGetMainWnd()*/))
	{ 
		DWORD dwErr=GetLastError();
		TCHAR szErrBuf[255];
		_stprintf(szErrBuf,TEXT("Failed to create output box (err %lx).  Check to make sure all required components are installed - check the NS Basic manual and/or release notes for more information."),dwErr);
		::MessageBox((AfxGetMainWnd())?AfxGetMainWnd()->m_hWnd:0,szErrBuf,L"ERROR",MB_OK);
		return false;
	}
	//have to do this here, because doing it before now doesn't seem to work!
	gpOutputWindow->GetClientRect(&rectClient);

//CString strMessage;
//strMessage.Format( _T( "pre rectClient: %d %d %d %d" ), rectClient.left, rectClient.top, rectClient.right, rectClient.bottom );
//AfxMessageBox( (LPCTSTR)strMessage );

#ifndef _POCKET
	rectClient.top+=CommandBar_Height(gpOutputWindow->m_hCommandBar);
//strMessage.Format( _T( "post rectClient: %d %d %d %d" ), rectClient.left, rectClient.top, rectClient.right, rectClient.bottom );
//AfxMessageBox( (LPCTSTR)strMessage );
#endif

	gpOutputWindow->dlgOutput.myMoveWindow(&rectClient);

//gpOutputWindow->dlgOutput.GetWindowRect( &rectClient );
//strMessage.Format( _T( "dlgOutput: %d %d %d %d" ), rectClient.left, rectClient.top, rectClient.right, rectClient.bottom );
//AfxMessageBox( (LPCTSTR)strMessage );

	gpOutputWindow->dlgOutput.ShowWindow(SW_SHOW);
	gpOutputWindow->ShowWindow(SW_SHOW);
	gpOutputWindow->BringWindowToTop();
	//gpOutputWindow->UpdateWindow();
	gpOutputWindow->pEngine=pENGINE;

	//::MessageBox(gpOutputWindow->dlgOutput.m_hWnd,TEXT("InitScriptEngine"),TEXT(""),MB_OK);

	pENGINE->m_hWnd=gpOutputWindow->dlgOutput.m_hWnd;
	pENGINE->m_pcWnd=&(gpOutputWindow->dlgOutput);
	//pENGINE->m_hWnd=gpOutputWindow->m_hWnd;
	//pENGINE->m_pcWnd=gpOutputWindow;
	/*{
		TCHAR szBuf[100];
		wsprintf(szBuf,L"%lx",pENGINE->m_pcWnd);
		MessageBox(0,szBuf,L"",MB_OK);
	}*/

	pENGINE->InitScriptEngine();

	// Create an NSCEPictureBox as the replacement message box
	RECT rc2;
	rc2 = rectClient;
	++rc2.bottom;
	++rc2.right;

	if(!pDlgOutput->m_PictureBox2.CreateControl(IID_IPictureBox, L"", 
			WS_VISIBLE, rc2, pENGINE->m_pcWnd, IDC_PICTUREBOX2) )
	{
#if 1
#if 0
LPVOID lpMsgBuf;
FormatMessage( 
    FORMAT_MESSAGE_ALLOCATE_BUFFER | 
    FORMAT_MESSAGE_FROM_SYSTEM | 
    FORMAT_MESSAGE_IGNORE_INSERTS,
    NULL,
    GetLastError(),
    0, // Default language
    (LPTSTR) &lpMsgBuf,
    0,
    NULL 
);
#else
	wchar_t lpMsgBuf[40];
	unsigned int k;
	int err = GetLastError();
	k = 39;
	lpMsgBuf[k] = 0;
	do
	{
		lpMsgBuf[--k] = ((err % 10) + '0');
		err /= 10;
	} while (err);
#endif
// Process any inserts in lpMsgBuf.
// ...
// Display the string.
::MessageBox( NULL, (LPCTSTR)&(lpMsgBuf[k]), L"Error Creating Control", MB_OK | MB_ICONINFORMATION );
// Free the buffer.
//LocalFree( lpMsgBuf );

		//::MessageBox(AfxGetMainWnd()->m_hWnd,L"Cannot create picture box control.  Please make sure that all NSBasic components are installed.",TEXT("Error"),MB_OK);
#endif
	}


	//BSTR caption;

	//caption = SysAllocString(L"And did those teeth, in ancient times, walk upon England's mountans green?");

	pDlgOutput->m_PictureBox2.MoveWindow(&rc2,true);
	pDlgOutput->m_PictureBox2.ShowWindow(SW_SHOW);
	pDlgOutput->m_PictureBox2.SetShowCaption(true);
	//pDlgOutput->m_PictureBox2.SetCaption(caption);
	pDlgOutput->m_PictureBox2.SetFontSize(18);   //GWH 2/1/7
	pDlgOutput->m_PictureBox2.SetBackColor(0xC0C0C0L);
	pDlgOutput->m_PictureBox2.SetFocus();

	//SysFreeString(caption);

	//add the picturebox as 'output'
	//add an extra refcount so that the picturebox won't get destroyed by the object list
	//destructelements function.  This extra ref will be released by that function, then
	//the object will actually be destroyed when the window is destroyed.
	//OBJ_ISWINDOW SHOULD PREVENT DEREF NOW - I know it's not a window, but windows aren't explicitly der-refed, so it's 
	//a handy way to prevent that from happening..
	//gpOutputWindow->dlgOutput.m_PictureBox.GetControlUnknown()->AddRef();

	pENGINE->AddScriptObject(TEXT("output"),0,0,gpOutputWindow->dlgOutput.m_PictureBox2.GetControlUnknown(),OBJ_ISSOURCE|OBJ_ISWINDOW);

	/*{
		HRESULT hr;
		IUnknown *pUnk;
		const IID IID_IADOCERecordset = {0x4BEB93D5,0x28D8,0x11D1,{0x83,0x21,0x00,0xA0,0x24,0xA8,0x81,0x10}};
		const CLSID CLSID_ADOCERecordset = {0x4BEB93D3,0x28D8,0x11D1,{0x83,0x21,0x00,0xA0,0x24,0xA8,0x81,0x10}};

		hr = CoCreateInstance(CLSID_ADOCERecordset, NULL,
                        CLSCTX_INPROC_SERVER, IID_IADOCERecordset,
                        (void**)&pUnk);
		

		pENGINE->AddScriptObject(TEXT("rs"),0,0,pUnk,OBJ_ISSOURCE);
	}*/

	//**EVENTBUG
	/*{
		HRESULT hr;
		IUnknown *pUnk;							//{33337170-F789-11CE-86F8-0020AFD8C6DB}
		const CLSID CLSID_ADOCERecordset =    {0x33337170,0xF789,0x11CE,{0x86,0xF8,0x00,0x20,0xAF,0xD8,0xC6,0xDB}};
		//const CLSID CLSID_ADOCERecordset = {0x4BEB93D3,0x28D8,0x11D1,{0x83,0x21,0x00,0xA0,0x24,0xA8,0x81,0x10}};

		hr = CoCreateInstance(CLSID_ADOCERecordset, NULL,
                        CLSCTX_INPROC_SERVER, IID_IUnknown,
                        (void**)&pUnk);
		

		pENGINE->AddScriptObject(TEXT("ftp"),0,0,pUnk,OBJ_ISSOURCE|OBJ_ISWINDOW);
	}
*/

#if 0
	HINSTANCE g_hInst = AfxGetApp()->m_hInstance;

	HWND frameWindow = CreateWindow(L"BUTTON", L"EMP", WS_VISIBLE|WS_CHILD|BS_GROUPBOX,
	10, 40, 200, 200, pDlgOutput->m_PictureBox2.m_hWnd, NULL, g_hInst, NULL);

	HWND op1 = CreateWindow(L"BUTTON", L"Option 1", WS_VISIBLE|WS_CHILD|WS_TABSTOP|BS_AUTORADIOBUTTON|BS_NOTIFY,
		10, 40, 100, 20, frameWindow, NULL, g_hInst, NULL);
	HWND op2 = CreateWindow(L"BUTTON", L"Option 2", WS_VISIBLE|WS_CHILD|WS_TABSTOP|BS_AUTORADIOBUTTON|BS_NOTIFY,
		10, 70, 100, 20, frameWindow, NULL, g_hInst, NULL);

	::ShowWindow(frameWindow, SW_SHOW);
	::ShowWindow(op1, SW_SHOW);
	::ShowWindow(op2, SW_SHOW);
	::BringWindowToTop(frameWindow);
	::BringWindowToTop(op1);
	::BringWindowToTop(op2);
#endif

	pENGINE->RunScript(pENGINE->m_scriptpreamble,false); 
	return true;
}

void CScriptDoc::DoRunDocument(bool bInitEnvironment)
{
	int iLen;
	TCHAR *szScript;
// CString strMessage;
// if( !bInitEnvironment )
// MessageBox( 0, _T( "bInitEnvironment = FALSE" ), _T( "CScriptDoc::DoRunDocument" ), MB_OK );

	// 03/05/2001 MMD
	// This to fix POCKET PC patch that hides code in edit window and CHAIN
	// If we init environment, code is in m_strCode and in window
	// If not, it is only in m_strCode
	if( bInitEnvironment )
	{
		iLen=((CEditView*)m_viewList.GetHead())->GetEditCtrl().GetWindowTextLength();
	}
	else
	{
		iLen = m_strCode.GetLength();
// strMessage.Format( _T( "%d" ), iLen );
// MessageBox( 0, strMessage, _T( "iLen" ), MB_OK );
	}
	szScript=(TCHAR *)LocalAlloc(LPTR,sizeof(TCHAR)*(iLen+2));
	if(!szScript)
	{	MessageBox(NULL,TEXT("Could not allocate memory for script."),TEXT("ERROR"),MB_OK);
		return;
	}

	if( bInitEnvironment )
		((CEditView*)m_viewList.GetHead())->GetEditCtrl().GetWindowText(szScript, iLen+1);
	else
		_tcscpy( szScript, (LPCTSTR)m_strCode );
	
	pENGINE->RunScript(szScript,bInitEnvironment,NULL,this);
	gbScriptRunning=true;
	LocalFree(szScript);
}

void CScriptDoc::OnToolRun() 
{
   int iLen;
	//TCHAR *szScript;
	//HCURSOR hcursorOld=SetCursor(LoadCursor(NULL, IDC_WAIT));
	gbOverrideRunActivate=false;

#ifdef _POCKET
   if( !gbShowEditorWindow )
      AfxGetMainWnd()->SetWindowText( _T( "" ) );
#endif

   //DebugBreak();
	if(!gbFileHasValidChecksum && !gbProtectedFile)  //**AUGUST99 - added to allow launching of protected apps
	{
		SetWaitCursor(false);
		//SetCursor(ghCursorNormal);
		AfxGetMainWnd()->MessageBox(TEXT("This file does not appear to have been created by NS Basic/CE and cannot be launched."),TEXT("NS Basic/CE"),MB_OK);
		return;
	}
   doWriteDebug(TEXT("20"));

	if(gpOutputWindow)
	{
		gpOutputWindow->m_bLaunchedWithFile=false; //prevent auto-close of entire app
		gpOutputWindow->DestroyWindow();  // DIKEO this is where window is destroyed on return to editor
		AfxGetMainWnd()->PostMessage(WM_COMMAND,MAKEWPARAM(ID_TOOL_RUN,1),0);
		return;
	}

	//open the output window and run the preamble script..
	//if(!EnsureOutputWindowOpen())
	//	return;
	
	gbEnterModalLoop=true;

	//this flag will be un-set if we encounter a BYE or CHAIN.

   doWriteDebug(TEXT("21"));
	if (gpOutputWindow)
	gpOutputWindow->m_bLaunchedWithFile=m_bLaunching;

	m_bLaunching=false; //only once on launch!

	//gpOutputWindow->ShowWindow(SW_SHOW);

	CStringEx cstrScript;
   // 110800 MD - Added to hide code when in runtime mode
   if( gbShowEditorWindow )
   {
      iLen=((CEditView*)m_viewList.GetHead())->GetEditCtrl().GetWindowTextLength();

/*
	   szScript=(TCHAR *)LocalAlloc(LPTR,sizeof(TCHAR)*(iLen+2));
	   if(!szScript)
	   {	MessageBox(NULL,TEXT("Could not allocate memory for script."),TEXT("ERROR"),MB_OK);
		   goto exit_tool_run;
	   }
*/
      //((CEditView*)m_viewList.GetHead())->GetEditCtrl().GetWindowText(szScript, iLen+1);
	   ((CEditView*)m_viewList.GetHead())->GetEditCtrl().GetWindowText(cstrScript);
   }
   else
   {
      iLen = m_strCode.GetLength();
      cstrScript = m_strCode;
   }
	
	if(gbStep || gbTrace)
	{
		int iInsertCount=0;
		int iIndex, iIndexNext;
		int iScriptLen;
		CString cstrInsert, cstrTemp;
		const int kRunawayInsertCheck=10000;
		const TCHAR *kOptionExplicit=TEXT("OPTION EXPLICIT");
		const TCHAR *kRem = _T( "REM" );
		boolean bBrokenLine;
		boolean bFirstCode;

		iIndex=0;//cstrScript.Find(TEXT("\n"));

		// 05/31/2000 Added this because OE breaks us, whether it is at the top or not.
		// STEP/TRACE will allow a program to have a preamble remark section, in the
		// spirit of good programming policy.  Once REMs have cleared, we look for OE,
		// and then S/T our way through....
		iScriptLen=cstrScript.GetLength();
		bFirstCode = FALSE;
		while( !bFirstCode )
		{
			//skip any whitespace at the beginning of the script
			while(iIndex<iScriptLen && _istspace(cstrScript[iIndex]))
			{
				iIndex++;
				if(iIndex<iScriptLen && cstrScript[iIndex]==TEXT('\n'))
					iInsertCount++;
			}
			cstrTemp = cstrScript.Mid( iIndex, _tcslen( kRem ) );
			if( ( cstrScript[iIndex] == _T( '\'' ) ) || ( cstrTemp.CompareNoCase( kRem ) == 0 ) )
			{
				// Skip to end of line
				while( iIndex < iScriptLen && cstrScript[iIndex] != _T( '\n' ) )
					iIndex++;
				if( iIndex < iScriptLen && cstrScript[iIndex] == _T( '\n' ) )
					iInsertCount++;
			}
			else
				bFirstCode = TRUE;
		}

		// Is there an "OPTION EXPLICIT" at the top?
		// 05/31/2000 OE doesn't have to be at the top, it only has to be the first line
		// of code.  Comments that may precede OE will be ignored.
		cstrTemp=cstrScript.Mid(iIndex,_tcslen(kOptionExplicit));
		if(cstrTemp.CompareNoCase(kOptionExplicit)==0)
			iIndex+=_tcslen(kOptionExplicit);

		bBrokenLine=false;
		while(iIndex<iScriptLen && iIndex!=-1 && iInsertCount<kRunawayInsertCheck)
		{
			cstrInsert.Empty();
			//skip any whitespace 
			while(iIndex<iScriptLen && _istspace(cstrScript[iIndex]))
			{
				iIndex++;
				if(iIndex<iScriptLen && cstrScript[iIndex]==TEXT('\n'))
					iInsertCount++;
			}

			if(iIndex<iScriptLen /*(iIndex<2 || cstrScript[iIndex-2]!=L'_')*/) //if the previous line did not end with the line-break character
			{
				CStringEx cstrLine;
				int iLineLength;

				//find the next carriage return (so we can grab the line)
				iIndexNext=cstrScript.Find(TEXT("\n"),iIndex);

				if(iIndexNext==-1)
					iIndexNext=iScriptLen-1;
				if(iIndexNext==iIndex)
					cstrLine.Empty();
				else
				{
					cstrLine=(LPCTSTR)cstrScript.Mid(iIndex,(iIndexNext-iIndex)-1);
					cstrLine.TrimLeft();
					cstrLine.Replace(TEXT("\""),TEXT("\"\""));
					//cstrLine.Replace(TEXT('\"'),TEXT('\''));
				}
				if(!bBrokenLine)
				{
					if(gbTrace)
					{
						cstrInsert.Format(TEXT("\nprint \"Line %i - %s\" '*^%i^*"),iInsertCount++,cstrLine,iInsertCount);
					}
					else if (gbStep)
					{
						cstrInsert.Format(TEXT("\nbreak \"Line %i \"&VBCRLF&\"- %s\" '*^%i^*"),iInsertCount++,cstrLine,iInsertCount);
					}
	//				if(bFirst)
					cstrInsert+=TEXT("\n");
					//cstrScript.Insert(iIndex,cstrInsert);
					cstrScript=(LPCTSTR)cstrScript.Mid(0,iIndex)+cstrInsert+cstrScript.Right((cstrScript.GetLength()-iIndex)/*-(iIndex?1:0)*/);
				}

				iLineLength=cstrLine.GetLength();
				if(iLineLength>1 && cstrLine[iLineLength-1]==TEXT('_')
					|| _tcsnicmp((LPCTSTR)cstrLine,TEXT("SELECT CASE"),11)==0) //skip the next line.
					bBrokenLine=true;
				else
					bBrokenLine=false;
			}
			else
				cstrInsert.Empty();
			iIndex=cstrScript.Find(TEXT("\n"),iIndex+cstrInsert.GetLength()+1);
			iScriptLen=cstrScript.GetLength();
		}


	}
	//OutputDebugString(cstrScript);
	if(gbEnterModalLoop) //only first run
		pENGINE->m_pcstrDebugScript=&cstrScript;
	//pENGINE->RunScript(szScript,false,NULL,this);
	pENGINE->RunScript(cstrScript,false,NULL,this);  //GHW 2009: If I comment out this line, the GWES error still happens.
	gbScriptRunning=true;
	//LocalFree(szScript);
	//pENGINE->RunScript(L"\nwait\n",false,NULL,this);
	//pENGINE->RunScript(L"\ndim xyzzy");
	//pENGINE->m_pcWnd->RunModalLoop();
	
	if(gbEnterModalLoop)
	{//**EVENTBUG
		pENGINE->SendScriptMessage(TEXT("main"),VT_EMPTY,0,0);
		AfxGetMainWnd()->RunModalLoop();
	}
	DebugStr(L"End of Tool/Run\n");
//exit_tool_run:
	//SetCursor(hcursorOld);
	0;
}

void CScriptDoc::OnToolsExecutecode() 
{
	CExecuteDialog dlg;
	static bool bFirstRun=true;
	static CString cstrCode;
	bool bSave;

	if(bFirstRun)
	{
		cstrCode.Empty();
		bFirstRun=false;
	}
	else
		dlg.m_cstrText=cstrCode;

	//make sure the output window is open, and the environment initialized
	if(!EnsureOutputWindowOpen())
		return;

	if(dlg.DoModal()!=IDOK)
		return;

	//save the "last" value in the execute window
	cstrCode=dlg.m_cstrText;

	//bring the output window to the foreground..
   doWriteDebug(TEXT("23"));
	if (gpOutputWindow)
	{
		gpOutputWindow->BringWindowToTop();
		gpOutputWindow->ShowWindow(SW_SHOW);
	}

	bSave=gbScrollToError;
	gbScrollToError=false;
	pENGINE->RunScript(dlg.m_cstrText,false,NULL,this);
	gbScrollToError=bSave;
}

void CScriptDoc::OnToolsShowvariable() 
{

	CInputLineDialog dlg;
	TCHAR szScript[255];
	bool bSave;

	dlg.m_cstrPrompt=L"Show Variable";

	if(!EnsureOutputWindowOpen())
		return;

	if(dlg.DoModal()!=IDOK)
		return;
	if (dlg.m_cstrText.IsEmpty())
		return;

	_tcscpy(szScript,TEXT("msgbox "));
	_tcscat(szScript,dlg.m_cstrText);
	_tcscat(szScript,TEXT(",0,\"Value of "));
	_tcscat(szScript,dlg.m_cstrText);
	_tcscat(szScript,TEXT("\"\n"));

	bSave=gbScrollToError;
	gbScrollToError=false;
	pENGINE->RunScript(szScript,false,NULL,this);
	AfxGetMainWnd()->BringWindowToTop();
	gbScrollToError=bSave;

}

void CScriptDoc::OnToolsContinue() 
{
	bool bSave;

	CFunctionListDialog dlgList;
	CExecuteDialog dlgExecute;

	dlgList.m_bSorted=true;
	dlgList.m_cstrCaption=TEXT("Continue...");
	dlgList.m_cstrButton=TEXT("Execute function");
	dlgList.m_pEditView=((CEditView*)m_viewList.GetHead());
	dlgList.m_acstrMatches.RemoveAll();

	dlgList.m_acstrMatches.Add(TEXT("sub "));
	dlgList.m_acstrMatches.Add(TEXT("function "));

	if(dlgList.DoModal()!=IDOK || dlgList.m_iSelectionLine==-1)
		return;

	if(!EnsureOutputWindowOpen())
		return;

	dlgList.m_cstrSelection.TrimLeft();
	if(_tcsnicmp(dlgList.m_cstrSelection,TEXT("public"),6)==0)
		dlgList.m_cstrSelection=dlgList.m_cstrSelection.Mid(6);
	dlgList.m_cstrSelection.TrimLeft();

	if(_tcsnicmp(dlgList.m_cstrSelection,TEXT("private"),7)==0)
		dlgList.m_cstrSelection=dlgList.m_cstrSelection.Mid(7);
	dlgList.m_cstrSelection.TrimLeft();

	if(_tcsnicmp(dlgList.m_cstrSelection,TEXT("function"),8)==0)
		dlgList.m_cstrSelection=dlgList.m_cstrSelection.Mid(8);
	dlgList.m_cstrSelection.TrimLeft();

	if(_tcsnicmp(dlgList.m_cstrSelection,TEXT("sub"),3)==0)
		dlgList.m_cstrSelection=dlgList.m_cstrSelection.Mid(3);
	dlgList.m_cstrSelection.TrimLeft();


	dlgExecute.m_cstrText=dlgList.m_cstrSelection;

		
	if(dlgExecute.DoModal()!=IDOK)
		return;

   doWriteDebug(TEXT("24"));
	if (gpOutputWindow)
	{
		gpOutputWindow->BringWindowToTop();
		gpOutputWindow->ShowWindow(SW_SHOW);
	}

	bSave=gbScrollToError;
	gbScrollToError=false;
	pENGINE->RunScript(dlgExecute.m_cstrText,false,NULL,this);
	gbScrollToError=bSave;


	
}

void CScriptDoc::OnUpdateToolsContinue(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(gbScriptRunning);
}

void CScriptDoc::OnToolsStats() 
{
	CEditView *view=((CEditView*)m_viewList.GetHead());
	CEdit& doc=view->GetEditCtrl();
	int iEndDoc=doc.GetWindowTextLength();
	const TCHAR *szBuf;
	TCHAR szMsg[100];
	TCHAR szTempBuf[50];
	int iNumLines,iIndex;

	szBuf=view->LockBuffer();

	iNumLines=iIndex=0;
	while(iIndex<iEndDoc)
	{
		if(szBuf[iIndex]==L'\r')
			iNumLines++;
		iIndex++;
	}
	//this captures the last line if it has data on it (but no terminating linefeed/cr)
	if (iEndDoc>= 1 && szBuf[iEndDoc-1]!=TEXT('\n'))
		iNumLines++;


	view->UnlockBuffer();
	
	
	wsprintf(szMsg,TEXT("The script is %i %s long, and occupies %s."),iNumLines,(iNumLines==1)?TEXT("line"):TEXT("lines"),doBuildSizeString(iEndDoc*2,szTempBuf));

	MessageBox(AfxGetMainWnd()->m_hWnd,szMsg,TEXT("Statistics"),MB_OK);

	
}

void CScriptDoc::SetDocumentTitle(const TCHAR *lpszPathName)
{
	TCHAR *szTitle;
	
	szTitle=(TCHAR *)lpszPathName+_tcslen(lpszPathName);
	while(*szTitle != TEXT('\\') && *szTitle!= TEXT(':') && szTitle>lpszPathName)
	{
		//if there's a period, chop it off,,,
		//if(*szTitle==TEXT('.'))
		//	*szTitle=0;
		szTitle--;
	}
#ifndef _POCKET
	CWnd *pWnd;
	CString cstrTitle;
	//cstrTitle=TEXT("EDIT:");
	cstrTitle+=((*lpszPathName!=TEXT('\\') && *lpszPathName!=TEXT(':'))?szTitle:(++szTitle)); //**MARCH99 - don't skip the first char if it's not a backslash
	pWnd=AfxGetMainWnd();
	if(pWnd)
		pWnd->SetWindowText(cstrTitle);
#endif
}

BOOL CScriptDoc::DoOnOpenDocument(LPCTSTR lpszPathName)
{
	/* EMP additions to use embedded document September 2005*/
	LPCTSTR runner;

	for (runner = lpszPathName; *runner; ++runner) {}
	--runner;

	while (runner > lpszPathName && '.' != *runner) --runner;

	isExe = ((0 == wcscmp(runner, L".exe")) ||
			 (0 == wcscmp(runner, L".exE")) ||
			 (0 == wcscmp(runner, L".eXe")) ||
			 (0 == wcscmp(runner, L".eXE")) ||
			 (0 == wcscmp(runner, L".Exe")) ||
			 (0 == wcscmp(runner, L".ExE")) ||
			 (0 == wcscmp(runner, L".EXe")) ||
			 (0 == wcscmp(runner, L".EXE")));

	if (isExe)
	{
		gbCloseOnEnd = TRUE;
		gbCanOpenPlainFiles = TRUE;
	}

	SetWaitCursor(false); //**MARCH99 new

	if (!CDocument::OnOpenDocument(lpszPathName))
		return FALSE;

	SetDocumentTitle(lpszPathName);
	return TRUE;
}

BOOL CScriptDoc::OnOpenDocument(LPCTSTR lpszPathName) 
{
	BOOL retval;
	CWnd *pMainWnd=AfxGetMainWnd();
 //MessageBox( 0, _T( "Arrival" ), _T( "CScriptDoc::OnOpenDocument" ), MB_OK );
// MessageBeep( MB_ICONQUESTION );

	if(!pMainWnd)
		pMainWnd=gpcwndMain;
	//open doesn't work in Runtime mode or 
	//when you've opened a protected app unless you're opening on launch, 
	//or the force flag is set (used for CHAIN)
	if(!gbShowEditorWindow && !gbLaunching && !gbForceAllowOpen)
	{
// MessageBox( 0, _T( "Falling Out" ), _T( "CScriptDoc::OnOpenDocument" ), MB_OK );
		return false;
	}

	if(gbLaunching && !gbSquelchAutoLaunch)
		gbShowEditorWindow=false;

   doWriteDebug(TEXT("25"));
	if(gpOutputWindow)
		gpOutputWindow->m_bLaunchedWithFile=false; //prevent auto-close of entire app

	retval= DoOnOpenDocument(lpszPathName);

	if(!retval)
	{ 
// MessageBox( 0, _T( "Falling Out 2" ), _T( "CScriptDoc::OnOpenDocument" ), MB_OK );
		goto exit_on_open_document;
	}
	m_bLaunching=false;

	if(gbCanOpenPlainFiles)
		gbFileHasValidChecksum=true;
	//in runtime mode, this flag will be set by the serialization code..

	if(!gbFileHasValidChecksum && !gbProtectedFile) //**AUGUST99 added !gbProtectedFile check so runtime versions can launch protected files.
	{
		SetWaitCursor(false);
		//SetCursor(ghCursorNormal);
		OnNewDocument();
		
		pMainWnd->MessageBox(TEXT("This file does not appear to have been created by NS Basic/CE and cannot be loaded or launched."),TEXT("NS Basic/CE"),MB_OK);
		retval=false;
		goto exit_on_open_document;
	}
	
	if(gbLaunching)
	{
		gbLaunching=false; //flag that we did something
		if(!gbSquelchAutoLaunch)
		{//**MARCH99 new
			m_bLaunching=true;
			//post a message to run the app.  Have to post instead of running directly so
			//initialization can complete, and because ToolRun will block until the script
			//exits.
			
			//AfxGetMainWnd()->PostMessage(WM_COMMAND,MAKEWPARAM(ID_TOOL_RUN,1),0);
			pMainWnd->PostMessage(WM_COMMAND,MAKEWPARAM(ID_TOOL_RUN,1),0);
		}
	}
	else if (gbProtectedFile && (!gbForceAllowOpen || gbShowEditorWindow))
	{
		//SetCursor(ghCursorNormal);
		SetWaitCursor(false);
		OnNewDocument();
		//SetFlagsForLaunchMode();
		pMainWnd->MessageBox(TEXT("This file is protected and cannot be opened inside NS Basic/CE.  Launch it directly instead."),TEXT("NS Basic/CE"),MB_OK);
		retval=false;
		goto exit_on_open_document;
	}

exit_on_open_document:
	gbForceAllowOpen=false;
	return retval;
}

BOOL CScriptDoc::OnSaveDocument(LPCTSTR lpszPathName) 
{	
	BOOL bRetval;
	
	if(gbAllowSave && !isExe)
		bRetval=CDocument::OnSaveDocument(lpszPathName);
	else
	{
		//SetCursor(ghCursorNormal);
		SetWaitCursor(false);
		AfxGetMainWnd()->MessageBox(TEXT("This version of NS Basic/CE does not support saving."),TEXT("Error"),MB_OK);
		return true;
	}

	SetDocumentTitle(lpszPathName);
	gbFileHasValidChecksum=true; //we've just saved, so the checksum must be good.
	return bRetval;
}


//ripped from CDocManager
BOOL CScriptDoc::DoPromptFileName(CString& fileName, UINT nIDSTitle, DWORD lFlags, BOOL bOpenFileDialog, CDocTemplate* pTemplate)
{
	return ((CScriptApp *)AfxGetApp())->DoPromptFileName(fileName,nIDSTitle,lFlags,bOpenFileDialog,pTemplate);
}

//ripped from CDocument
BOOL CScriptDoc::DoSave(LPCTSTR lpszPathName, BOOL bReplace)
	// Save the document data to a file
	// lpszPathName = path name where to save document file
	// if lpszPathName is NULL then the user will be prompted (SaveAs)
	// note: lpszPathName can be different than 'm_strPathName'
	// if 'bReplace' is TRUE will change file name if successful (SaveAs)
	// if 'bReplace' is FALSE will not change path name (SaveCopyAs)
{
	CString newName = lpszPathName;

	if (newName.IsEmpty())
	{
		CDocTemplate* pTemplate = GetDocTemplate();
		ASSERT(pTemplate != NULL);

		newName = m_strPathName;
		if (bReplace && newName.IsEmpty())
		{
			newName = m_strTitle;
			// check for dubious filename
#if(_WIN32_WCE != 200)  //**JULY99 - no WCE_IF in HPC
			int iBad = newName.FindOneOf(WCE_IF(_T("#%;/\\"),_T(" #%;/\\")));
			if (iBad != -1)
				newName.ReleaseBuffer(iBad);
#endif
			// append the default suffix if there is one
			CString strExt;
			if (pTemplate->GetDocString(strExt, CDocTemplate::filterExt) &&
			  !strExt.IsEmpty())
			{
				ASSERT(strExt[0] == '.');
				newName += strExt;
			}
		}

		if (!/*AfxGetApp()->*/DoPromptFileName(newName,
		  bReplace ? AFX_IDS_SAVEFILE : AFX_IDS_SAVEFILECOPY,
		  OFN_HIDEREADONLY | OFN_PATHMUSTEXIST, FALSE, pTemplate))
			return FALSE;       // don't even attempt to save
	}

	CWaitCursor wait;

	if (!OnSaveDocument(newName))
	{
		if (lpszPathName == NULL)
		{
			// be sure to delete the file
			TRY
			{
				CFile::Remove(newName);
			}
			CATCH_ALL(e)
			{
				TRACE0("Warning: failed to delete file after failed SaveAs.\n");
				do { e->Delete(); } while (0);
			}
			END_CATCH_ALL
		}
		return FALSE;
	}

	// reset the title and change the document name
	if (bReplace)
		SetPathName(newName);

	return TRUE;        // success
}

void CScriptDoc::OnCloseDocument()
{
// EMP test #ifdef _POCKET
	/* EMP Exit on close document */
	AfxGetMainWnd()->PostMessage(WM_COMMAND,ID_APP_EXIT,0);
// EMP test #endif
	CDocument::OnCloseDocument();
}

void CScriptDoc::OnUpdateFileSave(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(gbAllowSave);
}

void CScriptDoc::OnUpdateFileSaveAs(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(gbAllowSave);
}

void CScriptDoc::OnUpdateToolsExecutecode(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(gbShowEditorWindow);
}

void CScriptDoc::OnUpdateToolsShowvariable(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(gbShowEditorWindow && gbScriptRunning);
}

void CScriptDoc::OnUpdateToolsStats(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(gbShowEditorWindow);
}

void CScriptDoc::OnUpdateToolRun(CCmdUI* pCmdUI) 
{
#ifdef _POCKET
   pCmdUI->SetText( _T( "Run" ) );
#endif
	pCmdUI->Enable((gbOverrideRunActivate || gbShowEditorWindow || m_bLaunching)?true:false);
}

void CScriptDoc::OnRunbutton() 
{
	if(gbShowEditorWindow)
		OnToolRun();
}

void CScriptDoc::OnUpdateRunbutton(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(gbShowEditorWindow);
}


void CScriptDoc::OnUpdateFileNew(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(gbShowEditorWindow);
}

void CScriptDoc::OnUpdateFileOpen(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(gbShowEditorWindow);
}



void CScriptDoc::OnUpdateFileSaveEncrypted(CCmdUI* pCmdUI) 
{

	if(gdwPrefFlags&kPrefSaveProtected)
	{
		pCmdUI->SetText(TEXT("Encryption ON"));
		pCmdUI->SetCheck(1);
	}
	else
	{
		pCmdUI->SetText(TEXT("Encryption OFF"));
		pCmdUI->SetCheck(0);
	}
	
}

void CScriptDoc::OnFileSaveEncrypted() 
{

	if(gdwPrefFlags&kPrefSaveProtected)
		gdwPrefFlags&=~kPrefSaveProtected;
	else
		gdwPrefFlags|=kPrefSaveProtected;
	// doWritePrefsFile(); Functionality pulled for 1.1
	SetModifiedFlag(true); //**JULY99 - set doc dirty flag.
	
}



void CScriptDoc::OnToolsStep() 
{
	gbStep=true;
	OnToolRun();
	gbStep=false;
}

void CScriptDoc::OnToolsTrace() 
{
	gbTrace=true;
	OnToolRun();
	gbTrace=false;
}


void CScriptDoc::OnToolsDesigner() 
{
	CString cstrParms;
	CString cstrPath;
	SHELLEXECUTEINFO info;
	bool bModified;
	const TCHAR *szTempPath=kMagicVNSBFilePath;
    TCHAR szKey[256];
	TCHAR szVNSBPath[MAX_PATH];

	HKEY hSubKey;
	LONG lResult;
	
	_tcscpy(szKey,TEXT("\\Software\\apps\\NSB Basic"));
	lResult = RegOpenKeyEx(HKEY_LOCAL_MACHINE, szKey, 0, 0, &hSubKey);
	if(lResult != ERROR_SUCCESS)
	{
		//use default path
		_tcscpy(szVNSBPath,kVNSBPath);
	
	}
	else
	{
		TCHAR strValueName[MAX_PATH];
		DWORD dwValueNameLength=sizeof(strValueName)/sizeof(TCHAR);
		DWORD dwType;

		lResult=RegQueryValueEx(hSubKey,TEXT("InstallDir"),0,&dwType,(unsigned char *)strValueName,&dwValueNameLength);

		if(lResult==ERROR_SUCCESS)
		{
			_tcscpy(szVNSBPath,strValueName);  //"program files"
			_tcscat(szVNSBPath,kNSBDirName);   //"\NS BASIC\"
			_tcscat(szVNSBPath,kVNSBAppName);  //"VNSB.EXE"
		}
		else
			_tcscpy(szVNSBPath,kVNSBPath);//default
		RegCloseKey(hSubKey);

	}
	memset(&info,0,sizeof(SHELLEXECUTEINFO));

	info.cbSize=sizeof(SHELLEXECUTEINFO);
	info.fMask=SEE_MASK_NOCLOSEPROCESS;
	info.hwnd=AfxGetMainWnd()->m_hWnd;
	info.lpVerb=TEXT("OPEN");
	
	info.lpFile=szVNSBPath;//kVNSBPath;

	//capture the state of the current document
//	bModified =IsModified();
	bModified = IsModified() ? TRUE : FALSE;
	cstrPath=GetPathName();
	//force the document to save off a copy
	//SetPathName(szTempPath,false);
	SetModifiedFlag(true);
	OnSaveDocument(szTempPath);
	//restore the old document state
	//SetPathName(cstrPath,false);
	SetModifiedFlag(bModified);

	//single or triple quote?  Docs say triple, but that screws up parm parser..
	//cstrParms=TEXT("\"\"\"");
	cstrParms=TEXT("\"");
	cstrParms+=kMagicVNSBFilePath;//kMagicVNSBFileName;
	//cstrParms+=TEXT("\"\"\" \"\"\"");
	cstrParms+=TEXT("\" \"");
	cstrParms+=GetPathName();
	//cstrParms+=TEXT("\"\"\"");
	cstrParms+=TEXT("\"");
	info.lpParameters=cstrParms;
	info.nShow=SW_SHOWNORMAL;

	//if we've successfully spawned off vnsb, close up shop..
	if(ShellExecuteEx(&info))
		PostQuitMessage(0);
	
}

#define ROTATELEFT(x,count) (((x)<<count) | ((x)>>((8*sizeof(x))-count)))
#define ROTATERIGHT(x,count) (((x)>>count) | ((x)<<((8*sizeof(x))-count)))

#define FLIPNIBBLE(x) ( ( (x&0xf0 >> 4) | (x&0x0f<<4) ) )

#define FLIPWORD(x) (    (FLIPNIBBLE((((unsigned short)x)&0xFF00) >> 8 )) | ( (FLIPNIBBLE(((unsigned short)x)&0xFF)) << 8 )   )

#define FLIPLONG(x)	( ( ( FLIPWORD((x&0xFFFF0000) >> 16 ) ) ) | ( (FLIPWORD(x&0xFFFF) << 16 ) ) )

#define kNSBFileFlagV1 0xFF0000DD
#define kNSBFileFlagV2 0xFF0011DD
#define kNSBFileFlagV3 0xFF0022DD
#define kNSBFileFlagV4 0xFF0044DD

/*
void CScriptDoc::ReadFromArchive(CArchive &ar, UINT nLen)
{
	ASSERT_VALID(this);
   LPTSTR lpszText = m_strCode.GetBuffer( ( nLen + 1 ) * sizeof( TCHAR ) );
   memset( lpszText, 0, ( nLen + 1 ) * sizeof( TCHAR ) );
//MD	LPVOID hText = LocalAlloc(LPTR, (nLen+1)*sizeof(TCHAR));
	DWORD dwChecksum, dwFileFlag, dwFileExtra1, dwFileExtra2, dwChecksumSeed;
	LPTSTR lpszActualText;
	UINT nRealLen=nLen;
	UINT nBytesToRead=0;
	DWORD dwSerialNumFromFile;
	DWORD x;
	DWORD x1;
	DWORD x2;

//MD	ASSERT(hText);

//MD	if (hText == NULL)
//MD		AfxThrowMemoryException();

//MD	LPTSTR lpszText = (LPTSTR)LocalLock(hText);
	ASSERT(lpszText != NULL);

	lpszActualText=lpszText;

	//pop off our DWORD which is our checksum..
	dwChecksum=0;
	ar.Read(&dwChecksum,sizeof(DWORD));
	dwFileFlag=dwChecksum;
	nLen-=(sizeof(DWORD)/sizeof(TCHAR));
	if(dwChecksum==kNSBFileFlagV1 || dwChecksum==kNSBFileFlagV2 || dwChecksum==kNSBFileFlagV3 || dwChecksum==kNSBFileFlagV4)
	{
		ar.Read(&dwChecksum,sizeof(DWORD));
		nLen-=(sizeof(DWORD)/sizeof(TCHAR));
	}
	else
	{
		//oops!  Not one of my files, so we need to give back the four chars we stole!
		memcpy(lpszText,&dwChecksum,sizeof(DWORD));
		lpszActualText=(TCHAR *)((char *)lpszActualText+sizeof(DWORD));	
		dwChecksum=dwFileFlag=0;
	}

	if(dwFileFlag==kNSBFileFlagV3||dwFileFlag==kNSBFileFlagV4)
	{
		//eight more bytes in the header for v3 format!
		ar.Read(&dwFileExtra1,sizeof(DWORD));
		nLen-=(sizeof(DWORD)/sizeof(TCHAR));
		//dwSerialNumFromFile=ROTATERIGHT(FLIPLONG(ROTATELEFT((dwFileExtra1),3)),6)^0xF163808F;
		//undo Checksum calculation 02.25.02 GH
		x=ROTATELEFT(dwFileExtra1,3);
		x1=dwChecksum&0xFFFF0000;
		x1=x1 >> 16;
		x1=FLIPWORD(x1);
		x2=dwChecksum&0xFFFF;
		x2=FLIPWORD(x2);
		x2=x2 << 16;
		x=x1 | x2;
		x=ROTATERIGHT(x,6);
		if(dwFileFlag==kNSBFileFlagV3)
			dwSerialNumFromFile=x^0xF163808F;
		else
			dwSerialNumFromFile=x^0xF808361F;

		ar.Read(&dwFileExtra2,sizeof(DWORD));
		nLen-=(sizeof(DWORD)/sizeof(TCHAR));
	}

	switch(dwFileFlag)
	{
	case kNSBFileFlagV3:
	case kNSBFileFlagV4:
		gdwPrefFlags|=kPrefSaveProtected; //**JULY99 - for #216
		if(gLaunchMode==LM_RUNTIME)
		{//runtime mode, we want to check the checksum as calculated from the serial number
			//TCHAR szBuf[200];
			//wsprintf(szBuf,L"%lu",dwSerialNumFromFile);
			dwChecksumSeed=dwSerialNumFromFile;
			//::MessageBox(0,L"RUNTIME",szBuf,MB_OK);
		}
		else //non-runtime, we need this calculation to see if this is "our" file.
			dwChecksumSeed=giSerialNumber;
		break;
	case 0: //plain file..
	default:
		gdwPrefFlags&=~kPrefSaveProtected; //**JULY99 - for #216
		dwChecksumSeed=0xF163808F;
		break;
	}

//MD	doWritePrefsFile();
	if(dwFileFlag==0 && dwChecksum==0)
	{//this is a "plain" file which means that nRealLen is bogus (because it was
		//calculated by taking the number of chars and dividing by two) - this is bad
		//for odd numbers.  So, we fix nRealLen by just re-fetching the length of the file.
		nRealLen=ar.GetFile()->GetLength(); //number of CHARS, which is also the number of BYTES for ascii

		nBytesToRead=nRealLen-sizeof(DWORD); 

	}
	else
		nBytesToRead=nLen*sizeof(TCHAR);

//afxDump << _T( "nBytesToRead = " ) << nBytesToRead << _T( "\n" );
	if(nRealLen>2)
	{
		if ((nBytesToRead - ar.Read(lpszActualText, nBytesToRead) > 2))
		{
//MD			LocalUnlock(hText);
//MD			LocalFree(hText);
         m_strCode.ReleaseBuffer();
			AfxThrowArchiveException(CArchiveException::endOfFile);
		}
	}
	// Replace the editing edit buffer with the newly loaded data
//afxDump << _T( "nRealLen = " ) << nRealLen << _T( "\n" );
	//this line not needed because the buffer starts out full of zeroes..
	//lpszText[nRealLen] = '\0';
//afxDump << _T( "lpszText Length = " ) << _tcslen( lpszText ) << _T( "\n" );
	if(dwFileFlag==kNSBFileFlagV2 || dwFileFlag==kNSBFileFlagV3 || dwFileFlag==kNSBFileFlagV4)
	{//encrypted v2 or v3, so de-encrypt it
		doDecryptV2(lpszText, nLen, dwFileFlag);
	}
	else if (dwFileFlag==0 && dwChecksum==0) //plain file
	{//plain ascii text.  we need to copy out
	 //our ascii and then convert it.
		char *pTempBuf;

		//nRealLen=ar.GetFile()->GetLength();
		pTempBuf=(char *)LocalAlloc(LPTR,nRealLen+1);
		if(!pTempBuf)
			AfxThrowArchiveException(CArchiveException::generic);
		memcpy(pTempBuf,lpszText,nRealLen);
		//original buffer isn't big enough because nLen is bogus
//MD		LocalFree(hText);
//MD		if((hText=(TCHAR *)LocalAlloc(LPTR,(nRealLen+1)*sizeof(TCHAR)) )== 0)
//MD		{
//MD			LocalFree(pTempBuf);
//MD			AfxThrowArchiveException(CArchiveException::generic);
//MD		}
//MD		lpszText=(TCHAR *)LocalLock(hText);

		mbstowcs(lpszText,pTempBuf,nRealLen);
		LocalFree(pTempBuf);
	}
//afxDump << _T( "lpszText Length = " ) << _tcslen( lpszText ) << _T( "\n" );

	if(dwFileFlag!=kNSBFileFlagV3 && dwFileFlag!=kNSBFileFlagV4 && gbCanOpenPlainFiles) //checksum MUST match for V3 files, regardless of whether this version can open plain files.
	{
		gbProtectedFile=false;
		gbFileHasValidChecksum=true;
	}
	else 
	{
		DWORD dwCheck=doCalculateChecksum(lpszText,dwChecksumSeed);
		
		/*
		{
			TCHAR szBuf[200];
			wsprintf(szBuf,L"%lu dwcheck %lu dwchecksum %lu",dwSerialNumFromFile,dwCheck,dwChecksum);
			::MessageBox(0,szBuf,L"",MB_OK);
		}
		* /

		if((dwFileFlag==kNSBFileFlagV3 || dwFileFlag==kNSBFileFlagV4) && dwCheck!=dwChecksum)
		{
			//gbCloseOnEnd=true;
			//gbAllowSave=false;
			//gbShowEditorWindow=false;
			gbProtectedFile=true;
		}
		else
		{
			//SetFlagsForLaunchMode();
			gbProtectedFile=false;
		}
		
		if(dwCheck==dwChecksum)
		{
			gbFileHasValidChecksum=true;
		}
		
	}
#if 0
   if (1)//(afxData.bWinCE)
	{
		// Set the text with SetWindowText, then free.
		// NOTE: Under WinCE, it is necessary to maintain a shadow buffer (since
		//       EM_GETHANDLE) doesn't seem to work for the client area.
		// NOTE: It is only updated when the control contents have been changed.
		BOOL bResult = ::SetWindowText(m_hWnd, lpszText);
		int nWindowLen;
		int nTextLen;
		nTextLen=_tcslen(lpszText);

		LocalUnlock(hText);
		LocalFree(hText);

		nWindowLen=::GetWindowTextLength(m_hWnd);
   	// make sure that SetWindowText was successful
		if (!bResult || nWindowLen < (int)nTextLen)
			AfxThrowMemoryException();

      // remove old shadow buffer
		delete[] m_pShadowBuffer;
		m_pShadowBuffer = NULL;
		m_nShadowSize = 0;

		ASSERT_VALID(this);
		return;
	}
#endif
//MD   LocalFree(hText);
   m_strCode.ReleaseBuffer();
//afxDump << _T( "m_strCode Length = " ) << m_strCode.GetLength() << _T( "\n" ) << m_strCode << _T( "\n" );
   //vc6fix
	/*
	LocalUnlock(hText);
	HLOCAL hOldText = GetEditCtrl().GetHandle();
	ASSERT(hOldText != NULL);
	LocalFree(hOldText);
	GetEditCtrl().SetHandle((HLOCAL)(UINT)(DWORD)hText);
	* /
//MD	Invalidate();
	ASSERT_VALID(this);
} // ReadFromArchive
*/

DWORD CScriptDoc::doCalculateChecksum(const TCHAR *szBuf, DWORD dwSeed)
{
	const TCHAR *szText=szBuf;
	DWORD dwChecksum;

	dwChecksum=dwSeed;

	while(*szBuf)
	{
		dwChecksum+=*(unsigned short *)szBuf;
		dwChecksum=(dwChecksum<<1)+((dwChecksum&0x80000000)>>31);
		szBuf++;
	}

	return dwChecksum;
} // doCalculateChecksum

void CScriptDoc::doDecryptV2(TCHAR *szBuf, UINT nLen, DWORD dwFileFlag)
{
	int iNumBits=(dwFileFlag==kNSBFileFlagV2)?3:5;
	TCHAR *pBuf=szBuf;
	while(nLen)
	{
		if(sizeof(TCHAR)==2)
			*pBuf=(TCHAR) FLIPWORD(*pBuf);
		else
			*pBuf=(TCHAR) FLIPNIBBLE(*pBuf);
		
		*pBuf=ROTATERIGHT(*pBuf,iNumBits);
		*pBuf++;
		nLen--;
	}
} // doDecryptV2

void CScriptDoc::WriteToArchive(CArchive &ar)
{
	DWORD dwSeed,dwFileFlag;
	ASSERT_VALID(this);
	CScriptView *pView = (CScriptView*)m_viewList.GetHead();
	LPCTSTR lpszText = pView->LockBuffer();
	ASSERT(lpszText != NULL);
	UINT nLen = pView->GetBufferLength();
	LPTSTR lpszCode;
	m_strCode.Empty();
	m_strCode.FreeExtra();
	lpszCode = m_strCode.GetBuffer( nLen + 1 );
	_tcsncpy( lpszCode, lpszText, nLen );
	lpszCode[nLen] = 0;
	pView->UnlockBuffer();
	lpszText = lpszCode;

	TRY
	{
		DWORD dwChecksum;
		DWORD x1;
		DWORD x2;
		CString cstrFileName;

		cstrFileName=ar.GetFile()->GetFileName();
		if(cstrFileName.Right(4).CompareNoCase(TEXT(".txt"))==0)
		{
			doWriteASCIIBytes(ar,lpszText,nLen);
		}
		else
		{
			if(gdwPrefFlags&kPrefSaveProtected)
			{
//				dwFileFlag=kNSBFileFlagV3;
				dwFileFlag=kNSBFileFlagV4;
				ar.Write(&dwFileFlag, sizeof(DWORD));

				dwSeed=giSerialNumber;
				dwChecksum=doCalculateChecksum(lpszText,dwSeed);
				ar.Write(&dwChecksum, sizeof(DWORD));

				//dwChecksum=ROTATERIGHT(FLIPLONG(ROTATELEFT((giSerialNumber^0xF163808F),6)),3);
				//new Checksum calculation gh 02.25.02
//				dwChecksum=giSerialNumber^0xF163808F;
				dwChecksum=giSerialNumber^0xF808361F;
//				dwChecksum=ROTATELEFT(dwChecksum,6);
				// Rotate Left 6
				x1 = dwChecksum & 0xFC000000;
				x1 = ( x1 >> 26 ) & 0x3F;
				x2 = dwChecksum &  0x03FFFFFF;
				x2 = ( x2 << 6 ) & 0xFFFFFFC0;
				dwChecksum = x1 | x2;
/** /
				x1=dwChecksum&0xFFFF0000;
				x1=x1 >> 16;
				x1=FLIPWORD(x1);
				x2=dwChecksum&0xFFFF;
				x2=FLIPWORD(x2);
				x2=x2 << 16;
				dwChecksum=x1 | x2;
/ **/
/**/
				// Flip Long
				x1 = dwChecksum		& 0xF0000000;
				x1 = ( x1 >> 28 )	& 0x0000000F;
				x2 = x1;
				x1 = dwChecksum		& 0x0F000000;
				x1 = ( x1 >> 20 )	& 0x000000F0;
				x2 = x1 | x2;
				x1 = dwChecksum		& 0x00F00000;
				x1 = ( x1 >> 12 )	& 0x00000F00;
				x2 = x1 | x2;
				x1 = dwChecksum		& 0x000F0000;
				x1 = ( x1 >>  4 )	& 0x0000F000;
				x2 = x1 | x2;
				x1 = dwChecksum		& 0x0000F000;
				x1 = ( x1 <<  4 )	& 0x000F0000;
				x2 = x1 | x2;
				x1 = dwChecksum		& 0x00000F00;
				x1 = ( x1 << 12 )	& 0x00F00000;
				x2 = x1 | x2;
				x1 = dwChecksum		& 0x000000F0;
				x1 = ( x1 << 20 )	& 0x0F000000;
				x2 = x1 | x2;
				x1 = dwChecksum		& 0x0000000F;
				x1 = ( x1 << 28 )	& 0xF0000000;
				dwChecksum = x1 | x2;
/**/
//				dwChecksum=ROTATERIGHT(dwChecksum,3);
				// Rotate Right 3
				x1 = dwChecksum		& 0x00000007;
				x1 = ( x1 << 29 )	& 0xE0000000;
				x2 = dwChecksum		& 0xFFFFFFF8;
				x2 = ( x2 >> 3 )	& 0x1FFFFFFF;
				dwChecksum = x1 | x2;
				ar.Write(&dwChecksum, sizeof(DWORD));
//cstrFileName.Format( _T("0x%lx"), dwChecksum );
//MessageBox( 0, cstrFileName, _T("dwChecksum"), 0 );

				dwChecksum=0;
// *** Don't ever uncomment this line for production!! ***
//				dwChecksum=giSerialNumber
				ar.Write(&dwChecksum, sizeof(DWORD));
			}
			else
			{
				dwFileFlag=kNSBFileFlagV2;
				ar.Write(&dwFileFlag, sizeof(DWORD));
				dwSeed=0xf163808f;
				dwChecksum=doCalculateChecksum(lpszText,dwSeed);
				ar.Write(&dwChecksum, sizeof(DWORD));
			}
			//ar.Write(lpszText, nLen*sizeof(TCHAR));
			doWriteEncryptedBytesV2(ar,lpszText,nLen,dwFileFlag);
		}
	}
	CATCH_ALL(e)
	{
//		UnlockBuffer();
m_strCode.ReleaseBuffer();
		THROW_LAST();
	}
	END_CATCH_ALL
//	UnlockBuffer();
m_strCode.ReleaseBuffer();
	ASSERT_VALID(this);
} // WriteToArchive

void CScriptDoc::doWriteASCIIBytes(CArchive &ar, const TCHAR *szBuf, UINT nLen)
{
	const TCHAR *pBuf=szBuf;
	while(nLen)
	{
		char c[2];
		wcstombs(c,pBuf,1);

		ar.Write(&c, sizeof(char));

		pBuf++;
		nLen--;
	}
} // doWriteASCIIBytes

void CScriptDoc::doWriteEncryptedBytesV2(CArchive &ar, const TCHAR *szBuf, UINT nLen, DWORD dwFileFlag)
{
	int iNumBits=(dwFileFlag==kNSBFileFlagV2)?3:5;
	const TCHAR *pBuf=szBuf;
	while(nLen)
	{
		TCHAR c=ROTATELEFT(*pBuf,iNumBits);
		if(sizeof(TCHAR)==2)
			c=(TCHAR) FLIPWORD(c);
		else
			c=(TCHAR) FLIPNIBBLE(c);
		ar.Write(&c, sizeof(TCHAR));

		pBuf++;
		nLen--;
	}
} // doWriteEncryptedBytesV2

void CScriptDoc::DeleteContents() 
{
   m_strCode.Empty();
	CDocument::DeleteContents();
} // DeleteContents

void CScriptDoc::ReadFromFile(CFile *pFile, UINT nLen, CString& cstrCode)
{
	ASSERT_VALID(this);
   LPTSTR lpszText = cstrCode.GetBuffer( ( nLen + 1 ) * sizeof( TCHAR ) );
   memset( lpszText, 0, ( nLen + 1 ) * sizeof( TCHAR ) );
//MD	LPVOID hText = LocalAlloc(LPTR, (nLen+1)*sizeof(TCHAR));
	DWORD dwChecksum, dwFileFlag, dwFileExtra1, dwFileExtra2, dwChecksumSeed;
	LPTSTR lpszActualText;
	UINT nRealLen=nLen;
	UINT nBytesToRead=0;
	DWORD dwSerialNumFromFile;
	DWORD x;
	DWORD x1;
	DWORD x2;
	LPCTSTR resource;
	LPCTSTR freeResource = NULL;
	HINSTANCE lib = NULL;
	ASSERT(lpszText != NULL);

	lpszActualText=lpszText;

	if (isExe)
	{		
		/* Load the resource string */
		wchar_t lpszPathName[MAX_PATH + 1];
		CString pathName = pFile -> GetFilePath();
		_tcsncpy(lpszPathName, pathName, MAX_PATH);

#if _WIN32_WCE >= 300
		HINSTANCE lib = LoadLibraryEx(pathName, NULL, LOAD_LIBRARY_AS_DATAFILE);
#else
		HINSTANCE lib = LoadLibrary(pathName);
#endif

		if (lib)
		{
			HRSRC rsc = FindResource(lib, MAKEINTRESOURCE(IDS_PROGRAMSTRING), RT_RCDATA);
			if (rsc)
			{
				DWORD size = SizeofResource(lib, rsc);

				HGLOBAL hRes = LoadResource(lib, rsc);

				if (hRes)
				{
#ifdef UTF8
					char *d = (char *)LockResource(hRes);
					char *m = new char[strlen(d) + 1];
					char *s;
					DWORD k;

					strcpy(m, d);

					for (s = m, k = 0; k < size; ++s, ++k)
					{
						*s = ~*s;
						char t;
						t = ((*s) >> 3) & 0x1F;
						t |= ((*s) << 5);
						*s = t;
					}

#if 0
					USES_CONVERSION;
					//wchar_t *crsc = A2W(m);
					
					//resource = SysAllocString(crsc);
					resource = A2BSTR(m);
					freeResource = resource;
#else

					/* Calculate length of resulting UTF-16 sequence */
					int len = 0;
					unsigned char *pUTF8;

					for (pUTF8 = (unsigned char *)m; *pUTF8; ++pUTF8)
					{
						if (0 == (0x80 & (*pUTF8)))
						{
							/* US-ASCII, single byte */
						}
						else if (0xC0 == (0xE0 & (*pUTF8)))
						{
							/* 2-byte sequence */
							++pUTF8;
						}
						else if (0xE0 == (0xF0 & (*pUTF8)))
						{
							/* 3-byte sequence */
							pUTF8 += 2;
						}
						else
						{
							/* Assume 4-byte sequence */
							pUTF8 += 3;
						}
						++len;
					}
					++len;

					resource = SysAllocStringLen(NULL, len);
					freeResource = resource;

					/* Now create the UTF-16 string */
					wchar_t *pUTF16 = (wchar_t *) resource;

					for (pUTF8 = (unsigned char *)m; *pUTF8; ++pUTF8)
					{
						if (0 == (0x80 & (*pUTF8)))
						{
							/* US-ASCII, single byte */
							*pUTF16 = *pUTF8;
						}
						else if (0xC0 == (0xE0 & (*pUTF8)))
						{
							/* 2-byte sequence */
							(*pUTF16) = (*pUTF8);
							(*pUTF16) = ((*pUTF16) & 0x1F) << 6;
							++pUTF8;
							(*pUTF16) |= ((*pUTF8) & 0x3F);
						}
						else if (0xE0 == (0xF0 & (*pUTF8)))
						{
							/* 3-byte sequence */
							(*pUTF16) = (*pUTF8);
							(*pUTF16) = (((*pUTF16) & 0x0F) << 12);
							++pUTF8;
							(*pUTF16) |= (((*pUTF8) & 0x3F) << 6);
							++pUTF8;
							(*pUTF16) |= ((*pUTF8) & 0x3F);
						}
						else
						{
							/* Assume 4-byte sequence */
							(*pUTF16) = (*pUTF8);
							(*pUTF16) = (((*pUTF16) & 0x07) << 18);
							++pUTF8;
							(*pUTF16) |= (((*pUTF8) & 0x3F) << 12);
							++pUTF8;
							(*pUTF16) |= (((*pUTF8) & 0x3F) << 6);
							++pUTF8;
							(*pUTF16) |= ((*pUTF8) & 0x3F);
						}
						++ pUTF16;
					}
					*pUTF16 = 0;

#endif

					delete m;
#else
					wchar_t *d = (wchar_t *)LockResource(hRes);
					resource = SysAllocString(d);
					wchar_t *s;
					
					/* De-obfuscate the string */
					for (s = (wchar_t *)resource; *s; ++s)
					{
						*s = ~*s;
						wchar_t t;

						t = ((*s) >> 3) & 0x1FFF;
						t |= ((*s) << 13);

						*s = t;
					}
					freeResource = resource;					
#endif
				}
				else
				{
					resource = NULL;
				}

			}
			else
			{
				resource = (LPCTSTR)LoadString(lib, IDS_PROGRAMSTRING, NULL, 0);
			}
			if (!resource)
			{
				MessageBox(NULL, L"Could not find program in executable", L"ERROR", MB_OK);
				FreeLibrary(lib);
				return;
			}
		}
		else 
		{
			MessageBox(NULL, L"This program requres Windows CE 3.0 or better.", L"ERROR", MB_OK);
			return;
		}
 	}

	//pop off our DWORD which is our checksum..
	dwChecksum=0;

	if (isExe)
	{
		memcpy(&dwChecksum, resource, sizeof(DWORD));
		resource = (LPCTSTR)(((DWORD *)resource) + 1);
	}
	else
	{
		pFile->Read(&dwChecksum,sizeof(DWORD));
	}
	dwFileFlag=dwChecksum;
	nLen-=(sizeof(DWORD)/sizeof(TCHAR));
	if(dwChecksum==kNSBFileFlagV1 || dwChecksum==kNSBFileFlagV2 || dwChecksum==kNSBFileFlagV3 || dwChecksum==kNSBFileFlagV4)
	{
		if (isExe)
		{
			memcpy(&dwChecksum, resource, sizeof(DWORD));
			resource = (LPCTSTR)(((DWORD *)resource) + 1);
		}
		else
		{
			pFile->Read(&dwChecksum,sizeof(DWORD));
		}
		nLen-=(sizeof(DWORD)/sizeof(TCHAR));
	}
	else
	{//oops!  Not one of my files, so we need to give back the four chars we stole!
		memcpy(lpszText,&dwChecksum,sizeof(DWORD));
		lpszActualText=(TCHAR *)((char *)lpszActualText+sizeof(DWORD));	
		dwChecksum=dwFileFlag=0;
	}
	if(dwFileFlag==kNSBFileFlagV3 || dwFileFlag==kNSBFileFlagV4)
	{//eight more bytes in the header for v3 format!
		if (isExe)
		{
			memcpy(&dwFileExtra1, resource, sizeof(DWORD));
			resource = (LPCTSTR)(((DWORD *)resource) + 1);
		}
		else
		{
			pFile->Read(&dwFileExtra1,sizeof(DWORD));
		}
		nLen-=(sizeof(DWORD)/sizeof(TCHAR));
		//dwSerialNumFromFile=ROTATERIGHT(FLIPLONG(ROTATELEFT((dwFileExtra1),3)),6)^0xF163808F;
		//undo Checksum calculation 02.25.02 GH
		x=ROTATELEFT(dwFileExtra1,3);
		x1=dwChecksum&0xFFFF0000;
		x1=x1 >> 16;
		x1=FLIPWORD(x1);
		x2=dwChecksum&0xFFFF;
		x2=FLIPWORD(x2);
		x2=x2 << 16;
		x=x1 | x2;
		x=ROTATERIGHT(x,6);
		if(dwFileFlag==kNSBFileFlagV3)
			dwSerialNumFromFile=x^0xF163808F;
		else
			dwSerialNumFromFile=x^0xF808361F;

		if (isExe)
		{
			memcpy(&dwFileExtra2, resource, sizeof(DWORD));
			resource = (LPCTSTR)(((DWORD *)resource) + 1);
		}
		else
		{
			pFile->Read(&dwFileExtra2,sizeof(DWORD));
		}
		nLen-=(sizeof(DWORD)/sizeof(TCHAR));
	}
	switch(dwFileFlag)
	{
	case kNSBFileFlagV3:
	case kNSBFileFlagV4:
		gdwPrefFlags|=kPrefSaveProtected; //**JULY99 - for #216
		if(gLaunchMode==LM_RUNTIME)
		{//runtime mode, we want to check the checksum as calculated from the serial number
			//TCHAR szBuf[200];
			//wsprintf(szBuf,L"%lu",dwSerialNumFromFile);
			dwChecksumSeed=dwSerialNumFromFile;
			//::MessageBox(0,L"RUNTIME",szBuf,MB_OK);
		}
		else //non-runtime, we need this calculation to see if this is "our" file.
			dwChecksumSeed=giSerialNumber;
		break;
	case 0: //plain file..
	default:
		gdwPrefFlags&=~kPrefSaveProtected; //**JULY99 - for #216
		dwChecksumSeed=0xF163808F;
		break;
	}
//MD	doWritePrefsFile();
	if(dwFileFlag==0 && dwChecksum==0 && !isExe)
	{//this is a "plain" file which means that nRealLen is bogus (because it was
		//calculated by taking the number of chars and dividing by two) - this is bad
		//for odd numbers.  So, we fix nRealLen by just re-fetching the length of the file.
		nRealLen=pFile->GetLength(); //number of CHARS, which is also the number of BYTES for ascii

		nBytesToRead=nRealLen-sizeof(DWORD); 
	}
	else
		nBytesToRead=nLen*sizeof(TCHAR);
//afxDump << _T( "nBytesToRead = " ) << nBytesToRead << _T( "\n" );
	if(nRealLen>2)
	{
		if (isExe)
		{
			memcpy(lpszActualText, resource, nBytesToRead);
		}
		else
		{
			if ((nBytesToRead - pFile->Read(lpszActualText, nBytesToRead) > 2))
			{
				cstrCode.ReleaseBuffer();
				AfxThrowArchiveException(CArchiveException::endOfFile);
			}
		}
	}
	//MessageBox(NULL, lpszText, L"Loading", MB_OK);
	// Replace the editing edit buffer with the newly loaded data
	//this line not needed because the buffer starts out full of zeroes..
	//lpszText[nRealLen] = '\0';
	if(dwFileFlag==kNSBFileFlagV2 || dwFileFlag==kNSBFileFlagV3 || dwFileFlag==kNSBFileFlagV4)
	{//encrypted v2 or v3, so de-encrypt it
// MessageBox( 0, _T( "Decrypting V2" ), _T( "ReadFromFile" ), MB_OK );
		doDecryptV2(lpszText, nLen, dwFileFlag);
	}
	else if (dwFileFlag==0 && dwChecksum==0) //plain file
	{
		if (!isExe)
		{
			//plain ascii text.  we need to copy out
			//our ascii and then convert it.
			char *pTempBuf;

			//nRealLen=ar.GetFile()->GetLength();
			pTempBuf=(char *)LocalAlloc(LPTR,nRealLen+1);
			if(!pTempBuf)
				AfxThrowArchiveException(CArchiveException::generic);
			memcpy(pTempBuf,lpszText,nRealLen);

			int converted = mbstowcs(lpszText,pTempBuf,nRealLen);
			*( lpszText + converted ) = _T('\0');
			LocalFree(pTempBuf);
		}
	}
//afxDump << _T( "lpszText Length = " ) << _tcslen( lpszText ) << _T( "\n" );

	if((dwFileFlag!=kNSBFileFlagV3 && dwFileFlag!=kNSBFileFlagV4) && gbCanOpenPlainFiles) //checksum MUST match for V3 files, regardless of whether this version can open plain files.
	{
		gbProtectedFile=false;
		gbFileHasValidChecksum=true;
	}
	else 
	{
		DWORD dwCheck=doCalculateChecksum(lpszText,dwChecksumSeed);
		
		/*
		{
			TCHAR szBuf[200];
			wsprintf(szBuf,L"%lu dwcheck %lu dwchecksum %lu",dwSerialNumFromFile,dwCheck,dwChecksum);
			::MessageBox(0,szBuf,L"",MB_OK);
		}
		*/

		if((dwFileFlag==kNSBFileFlagV3 || dwFileFlag==kNSBFileFlagV4 ) && dwCheck!=dwChecksum)
		{
			//gbCloseOnEnd=true;
			//gbAllowSave=false;
			//gbShowEditorWindow=false;
			gbProtectedFile=true;
		}
		else
		{
			//SetFlagsForLaunchMode();
			gbProtectedFile=false;
		}
		
		if(dwCheck==dwChecksum)
		{
			gbFileHasValidChecksum=true;
		}
		
	}
#if 0
   if (1)//(afxData.bWinCE)
	{
		// Set the text with SetWindowText, then free.
		// NOTE: Under WinCE, it is necessary to maintain a shadow buffer (since
		//       EM_GETHANDLE) doesn't seem to work for the client area.
		// NOTE: It is only updated when the control contents have been changed.
		BOOL bResult = ::SetWindowText(m_hWnd, lpszText);
		int nWindowLen;
		int nTextLen;
		nTextLen=_tcslen(lpszText);

		LocalUnlock(hText);
		LocalFree(hText);

		nWindowLen=::GetWindowTextLength(m_hWnd);
   	// make sure that SetWindowText was successful
		if (!bResult || nWindowLen < (int)nTextLen)
			AfxThrowMemoryException();

      // remove old shadow buffer
		delete[] m_pShadowBuffer;
		m_pShadowBuffer = NULL;
		m_nShadowSize = 0;

		ASSERT_VALID(this);
		return;
	}
#endif

    if (freeResource)
	{
		SysFreeString((wchar_t *)freeResource);
	}
	if (lib)
	{
		FreeLibrary(lib);
	}

//MD   LocalFree(hText);
   cstrCode.ReleaseBuffer();
//afxDump << _T( "m_strCode Length = " ) << m_strCode.GetLength() << _T( "\n" ) << m_strCode << _T( "\n" );
   //vc6fix
	/*
	LocalUnlock(hText);
	HLOCAL hOldText = GetEditCtrl().GetHandle();
	ASSERT(hOldText != NULL);
	LocalFree(hOldText);
	GetEditCtrl().SetHandle((HLOCAL)(UINT)(DWORD)hText);
	*/
//MD	Invalidate();
	ASSERT_VALID(this);
} // ReadFromFile

void CScriptDoc::OnChangedViewList() 
{
//	MessageBox( 0, _T("CScriptDoc::OnChangedViewList()"), 0, 0 );
//	if( m_viewList.GetCount() == 0 )
//		MessageBox( 0, _T("No more views"), 0, 0 );
	CDocument::OnChangedViewList();
}
